package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext4
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
public enum Ext4 {

    进货发票("进货发票", "进货发票"),
    退货发票("退货发票", "退货发票"),
    返利发票("返利发票", "返利发票"),
    转税率发票("转税率发票", "转税率发票"),
    调账发票("调账发票", "调账发票"),
    进口类发票("进口类发票", "进口类发票"),
    虚拟发票("虚拟发票", "虚拟发票"),
    物流退款发票("物流退款发票", "物流退款发票"),
    转仓发票("转仓发票", "转仓发票"),
    费用发票("费用发票", "费用发票"),
    退货_转税率发票("退货-转税率发票", "退货-转税率发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext4(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext4 fromCode(String code) {
        return Stream.of(Ext4.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
