package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * follow_up_status
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
public enum FollowUpStatus {

    _01("01", "换票与供应商协商中"),
    _02("02", "换票-供应商同意换票 (我司未收回)"),
    _03("03", "换票-我司已收票未交到税务组"),
    _04("04", "已换票"),
    _05("05", "放弃确认税金抵扣损失"),
    _06("06", "其他"),
    _00("00", "无");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FollowUpStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FollowUpStatus fromCode(String code) {
        return Stream.of(FollowUpStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
