package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * function_group_way
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
public enum FunctionGroupWay {

    _0("0", "未匹配"),
    _1("1", "自动"),
    _2("2", "手动");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FunctionGroupWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FunctionGroupWay fromCode(String code) {
        return Stream.of(FunctionGroupWay.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
