package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_pool_system_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
public enum InvoicePoolSystemType {

    SAP0("SAP0", "SAP 非协同"),
    SAP1("SAP1", "SAP 协同"),
    EAS0("EAS0", "EAS 非协同");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoicePoolSystemType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoicePoolSystemType fromCode(String code) {
        return Stream.of(InvoicePoolSystemType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
