package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * manage_status
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
public enum ManageStatus {

    _0("0", "非正常"),
    _1("1", "正常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ManageStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ManageStatus fromCode(String code) {
        return Stream.of(ManageStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
