package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * process_status
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
public enum ProcessStatus {

    _0("0", "未处理"),
    _1("1", "处理中"),
    _2("2", "处理成功"),
    _3("3", "处理失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProcessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessStatus fromCode(String code) {
        return Stream.of(ProcessStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
