package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recog_delete_way
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
public enum RecogDeleteWay {

    _0("0", "自动删除"),
    _1("1", "手动删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RecogDeleteWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecogDeleteWay fromCode(String code) {
        return Stream.of(RecogDeleteWay.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
