package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_pre_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
public enum TaxPreFlag {

    _0("0", "不享受"),
    _1("1", "享受"),
    _2("2", "无");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxPreFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxPreFlag fromCode(String code) {
        return Stream.of(TaxPreFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
