package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_auth
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceAuth implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 组织id
   */
  private Long orgId;
  /**
   * 勾选人id
   */
  private Long checkUserId;
  /**
   * 勾选时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;
  /**
   * 数据状态
   */
  private String dataStatus;
  /**
   * 认证方式
   */
  private String authStyle;
  /**
   * 抵扣用途
   */
  private String authUse;
  /**
   * 认证备注
   */
  private String authRemark;
  /**
   * 认证状态
   */
  private String authStatus;
  /**
   * 可抵扣税额
   */
  private BigDecimal effectiveTaxAmount;
  /**
   * 不抵扣原因
   */
  private String noAuthReason;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 勾选人姓名
   */
  private String checkUserName;
  /**
   * 底账确认日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authBussiDate;
  /**
   * 税款所属期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authTaxPeriod;
  /**
   * 底账获取时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime elTime;
  /**
   * 任务id
   */
  private String authTaskId;
  /**
   * 税件错误码
   */
  private String authTaxErrorCode;
  /**
   * 底账是否已到
   */
  private String elSyncFlag;
  /**
   * 农产品类型
   */
  private String ncpType;
  /**
   * 农产品处理类型
   */
  private String ncpHandleType;
  /**
   * 农产品处理状态
   */
  private String ncpHandleStatus;
  /**
   * 农产品处理时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime ncpHandleTime;
  /**
   * 农产品处理人姓名
   */
  private String ncpHandleUserName;
  /**
   * 农产品处理备注
   */
  private String ncpHandleRemark;
  /**
   * 农产品部分金额
   */
  private BigDecimal ncpPartAmount;
  /**
   * 发票风险等级
   */
  private String ncpManageStatus;
  /**
   * 可加计扣除税额
   */
  private BigDecimal ncpJjkcTaxAmount;
  /**
   * 剩余加计扣除税额
   */
  private BigDecimal ncpJjkcLeftTaxAmount;
  /**
   * 本次加计扣除税额
   */
  private BigDecimal ncpJjkcCurrentTaxAmount;
  /**
   * 是否用于加计扣除
   */
  private String ncpJjkcAuthUse;
  /**
   * 加计扣除提交状态
   */
  private String ncpJjkcSubmitStatus;
  /**
   * 加计扣除提交备注
   */
  private String ncpJjkcSubmitRemark;
  /**
   * 加计扣除状态
   */
  private String ncpJjkcStatus;
  /**
   * 加计扣除提交时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime ncpJjkcSubmitTime;
  /**
   * 累计加计扣除税额
   */
  private BigDecimal ncpJjkcAccumTaxAmount;
  /**
   * 是否取消过勾选
   */
  private String isCancelledCheck;
  /**
   * 勾选请求时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authRequestTime;
  /**
   * 取消勾选时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authCancelTime;
  /**
   * 是否国税取消认证
   */
  private String isTaxCancelAuth;
  /**
   * 国税取消认证时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxCancelAuthTime;
  /**
   * 实际认证方式
   */
  private String actualAuthWay;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 全电发票号码
   */
  private String allElectricInvoiceNo;
  /**
   * 国税状态最后变更时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lastModifyTime;
  /**
   * 认证状态
   */
  private String elFlag;

  /**
   * 对一关联关系 关联对象 invoiceMain
   */
  private Long authAndInvoiceMainRelationId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("org_id", orgId);
      map.put("check_user_id", checkUserId);
      map.put("check_time", BocpGenUtils.toTimestamp(checkTime));
      map.put("data_status", dataStatus);
      map.put("auth_style", authStyle);
      map.put("auth_use", authUse);
      map.put("auth_remark", authRemark);
      map.put("auth_status", authStatus);
      map.put("effective_tax_amount", effectiveTaxAmount);
      map.put("no_auth_reason", noAuthReason);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("check_user_name", checkUserName);
      map.put("auth_bussi_date", BocpGenUtils.toTimestamp(authBussiDate));
      map.put("auth_tax_period", BocpGenUtils.toTimestamp(authTaxPeriod));
      map.put("el_time", BocpGenUtils.toTimestamp(elTime));
      map.put("auth_task_id", authTaskId);
      map.put("auth_tax_error_code", authTaxErrorCode);
      map.put("el_sync_flag", elSyncFlag);
      map.put("ncp_type", ncpType);
      map.put("ncp_handle_type", ncpHandleType);
      map.put("ncp_handle_status", ncpHandleStatus);
      map.put("ncp_handle_time", BocpGenUtils.toTimestamp(ncpHandleTime));
      map.put("ncp_handle_user_name", ncpHandleUserName);
      map.put("ncp_handle_remark", ncpHandleRemark);
      map.put("ncp_part_amount", ncpPartAmount);
      map.put("ncp_manage_status", ncpManageStatus);
      map.put("ncp_jjkc_tax_amount", ncpJjkcTaxAmount);
      map.put("ncp_jjkc_left_tax_amount", ncpJjkcLeftTaxAmount);
      map.put("ncp_jjkc_current_tax_amount", ncpJjkcCurrentTaxAmount);
      map.put("ncp_jjkc_auth_use", ncpJjkcAuthUse);
      map.put("ncp_jjkc_submit_status", ncpJjkcSubmitStatus);
      map.put("ncp_jjkc_submit_remark", ncpJjkcSubmitRemark);
      map.put("ncp_jjkc_status", ncpJjkcStatus);
      map.put("ncp_jjkc_submit_time", BocpGenUtils.toTimestamp(ncpJjkcSubmitTime));
      map.put("ncp_jjkc_accum_tax_amount", ncpJjkcAccumTaxAmount);
      map.put("is_cancelled_check", isCancelledCheck);
      map.put("auth_request_time", BocpGenUtils.toTimestamp(authRequestTime));
      map.put("auth_cancel_time", BocpGenUtils.toTimestamp(authCancelTime));
      map.put("is_tax_cancel_auth", isTaxCancelAuth);
      map.put("tax_cancel_auth_time", BocpGenUtils.toTimestamp(taxCancelAuthTime));
      map.put("actual_auth_way", actualAuthWay);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("all_electric_invoice_no", allElectricInvoiceNo);
      map.put("last_modify_time", BocpGenUtils.toTimestamp(lastModifyTime));
      map.put("el_flag", elFlag);

      map.put("authAndInvoiceMainRelation.id", authAndInvoiceMainRelationId);
      return map;
  }

  public static InvoiceAuth fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceAuth entity = new InvoiceAuth();

    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStyle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("no_auth_reason")) {
      Object obj = map.get("no_auth_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoAuthReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthBussiDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthBussiDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthBussiDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthBussiDate(null);
      }
    }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthTaxPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthTaxPeriod(null);
      }
    }
    if(map.containsKey("el_time")) {
      Object obj = map.get("el_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setElTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setElTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setElTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setElTime(null);
      }
    }
    if(map.containsKey("auth_task_id")) {
      Object obj = map.get("auth_task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_tax_error_code")) {
      Object obj = map.get("auth_tax_error_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthTaxErrorCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("el_sync_flag")) {
      Object obj = map.get("el_sync_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElSyncFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_type")) {
      Object obj = map.get("ncp_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_type")) {
      Object obj = map.get("ncp_handle_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpHandleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_status")) {
      Object obj = map.get("ncp_handle_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_time")) {
      Object obj = map.get("ncp_handle_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNcpHandleTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setNcpHandleTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNcpHandleTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setNcpHandleTime(null);
      }
    }
    if(map.containsKey("ncp_handle_user_name")) {
      Object obj = map.get("ncp_handle_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpHandleUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_remark")) {
      Object obj = map.get("ncp_handle_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_part_amount")) {
      Object obj = map.get("ncp_part_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNcpPartAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNcpPartAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNcpPartAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNcpPartAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNcpPartAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ncp_manage_status")) {
      Object obj = map.get("ncp_manage_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpManageStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_tax_amount")) {
      Object obj = map.get("ncp_jjkc_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNcpJjkcTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNcpJjkcTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNcpJjkcTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNcpJjkcTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNcpJjkcTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_left_tax_amount")) {
      Object obj = map.get("ncp_jjkc_left_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNcpJjkcLeftTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNcpJjkcLeftTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNcpJjkcLeftTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNcpJjkcLeftTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNcpJjkcLeftTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_current_tax_amount")) {
      Object obj = map.get("ncp_jjkc_current_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNcpJjkcCurrentTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNcpJjkcCurrentTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNcpJjkcCurrentTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNcpJjkcCurrentTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNcpJjkcCurrentTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_auth_use")) {
      Object obj = map.get("ncp_jjkc_auth_use");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_submit_status")) {
      Object obj = map.get("ncp_jjkc_submit_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcSubmitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_submit_remark")) {
      Object obj = map.get("ncp_jjkc_submit_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcSubmitRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_status")) {
      Object obj = map.get("ncp_jjkc_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_submit_time")) {
      Object obj = map.get("ncp_jjkc_submit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNcpJjkcSubmitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setNcpJjkcSubmitTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNcpJjkcSubmitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setNcpJjkcSubmitTime(null);
      }
    }
    if(map.containsKey("ncp_jjkc_accum_tax_amount")) {
      Object obj = map.get("ncp_jjkc_accum_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNcpJjkcAccumTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNcpJjkcAccumTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNcpJjkcAccumTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNcpJjkcAccumTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNcpJjkcAccumTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("is_cancelled_check")) {
      Object obj = map.get("is_cancelled_check");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCancelledCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_request_time")) {
      Object obj = map.get("auth_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthRequestTime(null);
      }
    }
    if(map.containsKey("auth_cancel_time")) {
      Object obj = map.get("auth_cancel_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthCancelTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthCancelTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthCancelTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthCancelTime(null);
      }
    }
    if(map.containsKey("is_tax_cancel_auth")) {
      Object obj = map.get("is_tax_cancel_auth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsTaxCancelAuth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_cancel_auth_time")) {
      Object obj = map.get("tax_cancel_auth_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxCancelAuthTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTaxCancelAuthTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxCancelAuthTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxCancelAuthTime(null);
      }
    }
    if(map.containsKey("actual_auth_way")) {
      Object obj = map.get("actual_auth_way");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActualAuthWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("all_electric_invoice_no")) {
      Object obj = map.get("all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLastModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLastModifyTime(null);
      }
    }
    if(map.containsKey("el_flag")) {
      Object obj = map.get("el_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("authAndInvoiceMainRelation.id")) {
       Object obj = map.get("authAndInvoiceMainRelation.id");
       if(obj instanceof Long) {
         entity.setAuthAndInvoiceMainRelationId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setAuthAndInvoiceMainRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCheckTime(null);
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthStyle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("no_auth_reason")) {
      Object obj = map.get("no_auth_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNoAuthReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuthBussiDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuthBussiDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuthBussiDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuthBussiDate(null);
      }
    }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuthTaxPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuthTaxPeriod(null);
      }
    }
    if(map.containsKey("el_time")) {
      Object obj = map.get("el_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setElTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setElTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setElTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setElTime(null);
      }
    }
    if(map.containsKey("auth_task_id")) {
      Object obj = map.get("auth_task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_tax_error_code")) {
      Object obj = map.get("auth_tax_error_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthTaxErrorCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("el_sync_flag")) {
      Object obj = map.get("el_sync_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setElSyncFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_type")) {
      Object obj = map.get("ncp_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNcpType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_type")) {
      Object obj = map.get("ncp_handle_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNcpHandleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_status")) {
      Object obj = map.get("ncp_handle_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNcpHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_time")) {
      Object obj = map.get("ncp_handle_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setNcpHandleTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setNcpHandleTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNcpHandleTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setNcpHandleTime(null);
      }
    }
    if(map.containsKey("ncp_handle_user_name")) {
      Object obj = map.get("ncp_handle_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNcpHandleUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_remark")) {
      Object obj = map.get("ncp_handle_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNcpHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_part_amount")) {
      Object obj = map.get("ncp_part_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setNcpPartAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setNcpPartAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setNcpPartAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNcpPartAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setNcpPartAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ncp_manage_status")) {
      Object obj = map.get("ncp_manage_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNcpManageStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_tax_amount")) {
      Object obj = map.get("ncp_jjkc_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setNcpJjkcTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setNcpJjkcTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setNcpJjkcTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNcpJjkcTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setNcpJjkcTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_left_tax_amount")) {
      Object obj = map.get("ncp_jjkc_left_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setNcpJjkcLeftTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setNcpJjkcLeftTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setNcpJjkcLeftTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNcpJjkcLeftTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setNcpJjkcLeftTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_current_tax_amount")) {
      Object obj = map.get("ncp_jjkc_current_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setNcpJjkcCurrentTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setNcpJjkcCurrentTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setNcpJjkcCurrentTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNcpJjkcCurrentTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setNcpJjkcCurrentTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_auth_use")) {
      Object obj = map.get("ncp_jjkc_auth_use");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNcpJjkcAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_submit_status")) {
      Object obj = map.get("ncp_jjkc_submit_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNcpJjkcSubmitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_submit_remark")) {
      Object obj = map.get("ncp_jjkc_submit_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNcpJjkcSubmitRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_status")) {
      Object obj = map.get("ncp_jjkc_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNcpJjkcStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_submit_time")) {
      Object obj = map.get("ncp_jjkc_submit_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setNcpJjkcSubmitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setNcpJjkcSubmitTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNcpJjkcSubmitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setNcpJjkcSubmitTime(null);
      }
    }
    if(map.containsKey("ncp_jjkc_accum_tax_amount")) {
      Object obj = map.get("ncp_jjkc_accum_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setNcpJjkcAccumTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setNcpJjkcAccumTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setNcpJjkcAccumTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNcpJjkcAccumTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setNcpJjkcAccumTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("is_cancelled_check")) {
      Object obj = map.get("is_cancelled_check");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsCancelledCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_request_time")) {
      Object obj = map.get("auth_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuthRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuthRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuthRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuthRequestTime(null);
      }
    }
    if(map.containsKey("auth_cancel_time")) {
      Object obj = map.get("auth_cancel_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuthCancelTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuthCancelTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuthCancelTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuthCancelTime(null);
      }
    }
    if(map.containsKey("is_tax_cancel_auth")) {
      Object obj = map.get("is_tax_cancel_auth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsTaxCancelAuth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_cancel_auth_time")) {
      Object obj = map.get("tax_cancel_auth_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTaxCancelAuthTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTaxCancelAuthTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxCancelAuthTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTaxCancelAuthTime(null);
      }
    }
    if(map.containsKey("actual_auth_way")) {
      Object obj = map.get("actual_auth_way");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setActualAuthWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("all_electric_invoice_no")) {
      Object obj = map.get("all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLastModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setLastModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLastModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setLastModifyTime(null);
      }
    }
    if(map.containsKey("el_flag")) {
      Object obj = map.get("el_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setElFlag((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("authAndInvoiceMainRelation.id")) {
    Object obj = map.get("authAndInvoiceMainRelation.id");
    if(obj instanceof Long) {
        this.setAuthAndInvoiceMainRelationId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setAuthAndInvoiceMainRelationId(Long.parseLong((String)obj));
    }
  }
  }
}
