package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.validator;

import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(IssueFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IssueFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IssueFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialInvoiceFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SpecialInvoiceFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SpecialInvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SaleListFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SaleListFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SaleListFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecogStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecogStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogSheet.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecogSheet.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecogSheet.class.getSimpleName());
            }
        }
        if(clazz.equals(FileType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FileType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FileType.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VerifyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VerifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifySignStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VerifySignStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VerifySignStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStyle.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStyle.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStyle.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthUse.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthUse.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoAuthReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoAuthReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoAuthReason.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceOrig.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceOrig.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceOrig.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CooperateFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CooperateFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ComplianceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RetreatStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HangStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HangStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HangStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SignForStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeUpStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BlackStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BlackStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BlackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TurnOutStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TurnOutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TurnOutType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TurnOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxRateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxRateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxRateType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPreFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxPreFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxPreFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(DiscountFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DiscountFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DiscountFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceColor.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceBusinessType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceBusinessType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceBusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(ErrorCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ErrorCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ErrorCode.class.getSimpleName());
            }
        }
        if(clazz.equals(SendStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SendStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SendStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SendType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SendType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SendType.class.getSimpleName());
            }
        }
        if(clazz.equals(BackStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BackStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiveStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceiveStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceiveStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FileOrigin.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FileOrigin.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FileOrigin.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyWay.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VerifyWay.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VerifyWay.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProcessStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProcessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsOpen.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsOpen.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsOpen.class.getSimpleName());
            }
        }
        if(clazz.equals(ElSyncFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ElSyncFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ElSyncFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceCategory.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceCategory.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AreaType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AreaType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsCancelCheck.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsCancelCheck.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsCancelCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(SaleConfirmStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SaleConfirmStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SaleConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReportStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReportStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReportStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReimbursementStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReimbursementStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReimbursementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ManageStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ManageStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ManageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InspectStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InspectStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InspectStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NcpType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NcpType.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpHandleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NcpHandleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NcpHandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpHandleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NcpHandleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NcpHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EntryStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EntryStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EntryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EntryTabStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EntryTabStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EntryTabStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpOperateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NcpOperateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NcpOperateType.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpManageStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NcpManageStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NcpManageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoComplianceFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoComplianceFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoComplianceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(NoComplianceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoComplianceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoComplianceType.class.getSimpleName());
            }
        }
        if(clazz.equals(NoComplianceLevel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoComplianceLevel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoComplianceLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(FollowUpStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FollowUpStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FollowUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskHandleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RiskHandleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RiskHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessControlStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessControlStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessControlStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FunctionGroup.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FunctionGroup.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FunctionGroup.class.getSimpleName());
            }
        }
        if(clazz.equals(FunctionGroupWay.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FunctionGroupWay.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FunctionGroupWay.class.getSimpleName());
            }
        }
        if(clazz.equals(LogisticsStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LogisticsStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LogisticsStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UnCertifiedReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UnCertifiedReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UnCertifiedReason.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxIncentivesType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxIncentivesType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxIncentivesType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceExt30.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceExt30.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceExt30.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceExt35.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceExt35.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceExt35.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpJjkcAuthUse.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NcpJjkcAuthUse.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NcpJjkcAuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpJjkcSubmitStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NcpJjkcSubmitStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NcpJjkcSubmitStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpJjkcStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NcpJjkcStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NcpJjkcStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsCancelledCheck.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsCancelledCheck.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsCancelledCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(OperateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OperateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OperateType.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskInvoiceCategory.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RiskInvoiceCategory.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RiskInvoiceCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(IsRepeat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsRepeat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsRepeat.class.getSimpleName());
            }
        }
        if(clazz.equals(IsNeedAuth.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsNeedAuth.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsNeedAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(IsSendException.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsSendException.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsSendException.class.getSimpleName());
            }
        }
        if(clazz.equals(ReturnType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReturnType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReturnType.class.getSimpleName());
            }
        }
        if(clazz.equals(ReturnBatch.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReturnBatch.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReturnBatch.class.getSimpleName());
            }
        }
        if(clazz.equals(NeedExpress.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NeedExpress.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NeedExpress.class.getSimpleName());
            }
        }
        if(clazz.equals(IsTaxCancelAuth.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsTaxCancelAuth.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsTaxCancelAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(ActualAuthWay.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ActualAuthWay.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ActualAuthWay.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogDeleteWay.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecogDeleteWay.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecogDeleteWay.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogBusinessType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecogBusinessType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecogBusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogDeleteRemark.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecogDeleteRemark.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecogDeleteRemark.class.getSimpleName());
            }
        }
        if(clazz.equals(IsLegalSynergetics.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsLegalSynergetics.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsLegalSynergetics.class.getSimpleName());
            }
        }
        if(clazz.equals(IsCheck.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsCheck.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(Bookkeeping.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Bookkeeping.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Bookkeeping.class.getSimpleName());
            }
        }
        if(clazz.equals(WithholdingAuthUse.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WithholdingAuthUse.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WithholdingAuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(WithholdingOperationType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WithholdingOperationType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WithholdingOperationType.class.getSimpleName());
            }
        }
        if(clazz.equals(ElFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ElFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ElFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoicePoolSystemType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoicePoolSystemType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoicePoolSystemType.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext26.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Ext26.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Ext26.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerIssuedStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SellerIssuedStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SellerIssuedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxRateDefinition.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxRateDefinition.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxRateDefinition.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext6.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Ext6.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Ext6.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SystemSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SystemSource.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext2.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Ext2.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Ext2.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext4.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Ext4.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Ext4.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
