package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.AbnormalInvoice;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IAbnormalInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 国税异常发票凭证前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class AbnormalInvoiceController {

  @Autowired
  private IAbnormalInvoiceService abnormalInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param abnormalInvoice 国税异常发票凭证
   * @return
   */
  @GetMapping("/abnormalinvoices" )
  public XfR getAbnormalInvoices(XfPage page, AbnormalInvoice abnormalInvoice) {
    return XfR.ok(abnormalInvoiceServiceImpl.page(page, Wrappers.query(abnormalInvoice)));
  }

  /**
   * 通过id查询国税异常发票凭证
   * @param  id
   * @return XfR
   */
  @GetMapping("/abnormalinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(abnormalInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增国税异常发票凭证
   * @param abnormalInvoice 国税异常发票凭证
   * @return XfR
   */
  @PostMapping("/abnormalinvoices")
  public XfR save(@RequestBody AbnormalInvoice abnormalInvoice) {
     return XfR.ok(abnormalInvoiceServiceImpl.save(abnormalInvoice));
  }

  /**
   * 修改-传入修改后的全部数据国税异常发票凭证
   * @param abnormalInvoice 国税异常发票凭证
   * @return XfR
   */
  @PutMapping("/abnormalinvoices/{id}")
  public XfR putUpdate(@RequestBody AbnormalInvoice abnormalInvoice,@PathVariable Long id) {
      abnormalInvoice.setId(id);
      return XfR.ok(abnormalInvoiceServiceImpl.updateById(abnormalInvoice));
  }

  /**
   * 修改-传入修改的数据国税异常发票凭证
   * @param abnormalInvoice 国税异常发票凭证
   * @return XfR
   */
  @PatchMapping("/abnormalinvoices/{id}")
  public XfR patchUpdate(@RequestBody AbnormalInvoice abnormalInvoice,@PathVariable Long id) {
      AbnormalInvoice upabnormalInvoice = abnormalInvoiceServiceImpl.getById(id);
      if(upabnormalInvoice != null){
        upabnormalInvoice = ObjectCopyUtils.copyProperties(abnormalInvoice,upabnormalInvoice,true);
      }
      return XfR.ok(abnormalInvoiceServiceImpl.updateById(upabnormalInvoice));
  }

  /**
   * 通过id删除国税异常发票凭证
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/abnormalinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(abnormalInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/abnormalinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "abnormal_invoice");
     params.put("request", condition);

     return XfR.ok(abnormalInvoiceServiceImpl.querys(params));
  }

}
