package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceItem;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票明细对象信息前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class InvoiceItemController {

  @Autowired
  private IInvoiceItemService invoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceItem 发票明细对象信息
   * @return
   */
  @GetMapping("/invoiceitems" )
  public XfR getInvoiceItems(XfPage page, InvoiceItem invoiceItem) {
    return XfR.ok(invoiceItemServiceImpl.page(page, Wrappers.query(invoiceItem)));
  }

  /**
   * 通过id查询发票明细对象信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增发票明细对象信息
   * @param invoiceItem 发票明细对象信息
   * @return XfR
   */
  @PostMapping("/invoiceitems")
  public XfR save(@RequestBody InvoiceItem invoiceItem) {
     return XfR.ok(invoiceItemServiceImpl.save(invoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据发票明细对象信息
   * @param invoiceItem 发票明细对象信息
   * @return XfR
   */
  @PutMapping("/invoiceitems/{id}")
  public XfR putUpdate(@RequestBody InvoiceItem invoiceItem,@PathVariable Long id) {
      invoiceItem.setId(id);
      return XfR.ok(invoiceItemServiceImpl.updateById(invoiceItem));
  }

  /**
   * 修改-传入修改的数据发票明细对象信息
   * @param invoiceItem 发票明细对象信息
   * @return XfR
   */
  @PatchMapping("/invoiceitems/{id}")
  public XfR patchUpdate(@RequestBody InvoiceItem invoiceItem,@PathVariable Long id) {
      InvoiceItem upinvoiceItem = invoiceItemServiceImpl.getById(id);
      if(upinvoiceItem != null){
        upinvoiceItem = ObjectCopyUtils.copyProperties(invoiceItem,upinvoiceItem,true);
      }
      return XfR.ok(invoiceItemServiceImpl.updateById(upinvoiceItem));
  }

  /**
   * 通过id删除发票明细对象信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_item");
     params.put("request", condition);

     return XfR.ok(invoiceItemServiceImpl.querys(params));
  }

}
