package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceMedicalService;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceMedicalServiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票医疗服务对象前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class InvoiceMedicalServiceController {

  @Autowired
  private IInvoiceMedicalServiceService invoiceMedicalServiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceMedicalService 发票医疗服务对象
   * @return
   */
  @GetMapping("/invoicemedicalservices" )
  public XfR getInvoiceMedicalServices(XfPage page, InvoiceMedicalService invoiceMedicalService) {
    return XfR.ok(invoiceMedicalServiceServiceImpl.page(page, Wrappers.query(invoiceMedicalService)));
  }

  /**
   * 通过id查询发票医疗服务对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicemedicalservices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceMedicalServiceServiceImpl.getById(id));
  }

  /**
   * 新增发票医疗服务对象
   * @param invoiceMedicalService 发票医疗服务对象
   * @return XfR
   */
  @PostMapping("/invoicemedicalservices")
  public XfR save(@RequestBody InvoiceMedicalService invoiceMedicalService) {
     return XfR.ok(invoiceMedicalServiceServiceImpl.save(invoiceMedicalService));
  }

  /**
   * 修改-传入修改后的全部数据发票医疗服务对象
   * @param invoiceMedicalService 发票医疗服务对象
   * @return XfR
   */
  @PutMapping("/invoicemedicalservices/{id}")
  public XfR putUpdate(@RequestBody InvoiceMedicalService invoiceMedicalService,@PathVariable Long id) {
      invoiceMedicalService.setId(id);
      return XfR.ok(invoiceMedicalServiceServiceImpl.updateById(invoiceMedicalService));
  }

  /**
   * 修改-传入修改的数据发票医疗服务对象
   * @param invoiceMedicalService 发票医疗服务对象
   * @return XfR
   */
  @PatchMapping("/invoicemedicalservices/{id}")
  public XfR patchUpdate(@RequestBody InvoiceMedicalService invoiceMedicalService,@PathVariable Long id) {
      InvoiceMedicalService upinvoiceMedicalService = invoiceMedicalServiceServiceImpl.getById(id);
      if(upinvoiceMedicalService != null){
        upinvoiceMedicalService = ObjectCopyUtils.copyProperties(invoiceMedicalService,upinvoiceMedicalService,true);
      }
      return XfR.ok(invoiceMedicalServiceServiceImpl.updateById(upinvoiceMedicalService));
  }

  /**
   * 通过id删除发票医疗服务对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicemedicalservices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceMedicalServiceServiceImpl.removeById(id));
  }

  @PostMapping("/invoicemedicalservices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_medical_service");
     params.put("request", condition);

     return XfR.ok(invoiceMedicalServiceServiceImpl.querys(params));
  }

}
