package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoicePassengerTransportations;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoicePassengerTransportationsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票旅客运输服务对象前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class InvoicePassengerTransportationsController {

  @Autowired
  private IInvoicePassengerTransportationsService invoicePassengerTransportationsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoicePassengerTransportations 发票旅客运输服务对象
   * @return
   */
  @GetMapping("/invoicepassengertransportationss" )
  public XfR getInvoicePassengerTransportationss(XfPage page, InvoicePassengerTransportations invoicePassengerTransportations) {
    return XfR.ok(invoicePassengerTransportationsServiceImpl.page(page, Wrappers.query(invoicePassengerTransportations)));
  }

  /**
   * 通过id查询发票旅客运输服务对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicepassengertransportationss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoicePassengerTransportationsServiceImpl.getById(id));
  }

  /**
   * 新增发票旅客运输服务对象
   * @param invoicePassengerTransportations 发票旅客运输服务对象
   * @return XfR
   */
  @PostMapping("/invoicepassengertransportationss")
  public XfR save(@RequestBody InvoicePassengerTransportations invoicePassengerTransportations) {
     return XfR.ok(invoicePassengerTransportationsServiceImpl.save(invoicePassengerTransportations));
  }

  /**
   * 修改-传入修改后的全部数据发票旅客运输服务对象
   * @param invoicePassengerTransportations 发票旅客运输服务对象
   * @return XfR
   */
  @PutMapping("/invoicepassengertransportationss/{id}")
  public XfR putUpdate(@RequestBody InvoicePassengerTransportations invoicePassengerTransportations,@PathVariable Long id) {
      invoicePassengerTransportations.setId(id);
      return XfR.ok(invoicePassengerTransportationsServiceImpl.updateById(invoicePassengerTransportations));
  }

  /**
   * 修改-传入修改的数据发票旅客运输服务对象
   * @param invoicePassengerTransportations 发票旅客运输服务对象
   * @return XfR
   */
  @PatchMapping("/invoicepassengertransportationss/{id}")
  public XfR patchUpdate(@RequestBody InvoicePassengerTransportations invoicePassengerTransportations,@PathVariable Long id) {
      InvoicePassengerTransportations upinvoicePassengerTransportations = invoicePassengerTransportationsServiceImpl.getById(id);
      if(upinvoicePassengerTransportations != null){
        upinvoicePassengerTransportations = ObjectCopyUtils.copyProperties(invoicePassengerTransportations,upinvoicePassengerTransportations,true);
      }
      return XfR.ok(invoicePassengerTransportationsServiceImpl.updateById(upinvoicePassengerTransportations));
  }

  /**
   * 通过id删除发票旅客运输服务对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicepassengertransportationss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoicePassengerTransportationsServiceImpl.removeById(id));
  }

  @PostMapping("/invoicepassengertransportationss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_passenger_transportations");
     params.put("request", condition);

     return XfR.ok(invoicePassengerTransportationsServiceImpl.querys(params));
  }

}
