package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceVehicle;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceVehicleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 机动车额外信息前端控制器
 *
 * @author ultraman
 * @date 2025-11-03
 */
@RestController
public class InvoiceVehicleController {

  @Autowired
  private IInvoiceVehicleService invoiceVehicleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceVehicle 机动车额外信息
   * @return
   */
  @GetMapping("/invoicevehicles" )
  public XfR getInvoiceVehicles(XfPage page, InvoiceVehicle invoiceVehicle) {
    return XfR.ok(invoiceVehicleServiceImpl.page(page, Wrappers.query(invoiceVehicle)));
  }

  /**
   * 通过id查询机动车额外信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicevehicles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceVehicleServiceImpl.getById(id));
  }

  /**
   * 新增机动车额外信息
   * @param invoiceVehicle 机动车额外信息
   * @return XfR
   */
  @PostMapping("/invoicevehicles")
  public XfR save(@RequestBody InvoiceVehicle invoiceVehicle) {
     return XfR.ok(invoiceVehicleServiceImpl.save(invoiceVehicle));
  }

  /**
   * 修改-传入修改后的全部数据机动车额外信息
   * @param invoiceVehicle 机动车额外信息
   * @return XfR
   */
  @PutMapping("/invoicevehicles/{id}")
  public XfR putUpdate(@RequestBody InvoiceVehicle invoiceVehicle,@PathVariable Long id) {
      invoiceVehicle.setId(id);
      return XfR.ok(invoiceVehicleServiceImpl.updateById(invoiceVehicle));
  }

  /**
   * 修改-传入修改的数据机动车额外信息
   * @param invoiceVehicle 机动车额外信息
   * @return XfR
   */
  @PatchMapping("/invoicevehicles/{id}")
  public XfR patchUpdate(@RequestBody InvoiceVehicle invoiceVehicle,@PathVariable Long id) {
      InvoiceVehicle upinvoiceVehicle = invoiceVehicleServiceImpl.getById(id);
      if(upinvoiceVehicle != null){
        upinvoiceVehicle = ObjectCopyUtils.copyProperties(invoiceVehicle,upinvoiceVehicle,true);
      }
      return XfR.ok(invoiceVehicleServiceImpl.updateById(upinvoiceVehicle));
  }

  /**
   * 通过id删除机动车额外信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicevehicles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceVehicleServiceImpl.removeById(id));
  }

  @PostMapping("/invoicevehicles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_vehicle");
     params.put("request", condition);

     return XfR.ok(invoiceVehicleServiceImpl.querys(params));
  }

}
