package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceVerifyPrompt;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceVerifyPromptService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 验真发票提示对象前端控制器
 *
 * @author ultraman
 * @date 2025-11-03
 */
@RestController
public class InvoiceVerifyPromptController {

  @Autowired
  private IInvoiceVerifyPromptService invoiceVerifyPromptServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceVerifyPrompt 验真发票提示对象
   * @return
   */
  @GetMapping("/invoiceverifyprompts" )
  public XfR getInvoiceVerifyPrompts(XfPage page, InvoiceVerifyPrompt invoiceVerifyPrompt) {
    return XfR.ok(invoiceVerifyPromptServiceImpl.page(page, Wrappers.query(invoiceVerifyPrompt)));
  }

  /**
   * 通过id查询验真发票提示对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceverifyprompts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceVerifyPromptServiceImpl.getById(id));
  }

  /**
   * 新增验真发票提示对象
   * @param invoiceVerifyPrompt 验真发票提示对象
   * @return XfR
   */
  @PostMapping("/invoiceverifyprompts")
  public XfR save(@RequestBody InvoiceVerifyPrompt invoiceVerifyPrompt) {
     return XfR.ok(invoiceVerifyPromptServiceImpl.save(invoiceVerifyPrompt));
  }

  /**
   * 修改-传入修改后的全部数据验真发票提示对象
   * @param invoiceVerifyPrompt 验真发票提示对象
   * @return XfR
   */
  @PutMapping("/invoiceverifyprompts/{id}")
  public XfR putUpdate(@RequestBody InvoiceVerifyPrompt invoiceVerifyPrompt,@PathVariable Long id) {
      invoiceVerifyPrompt.setId(id);
      return XfR.ok(invoiceVerifyPromptServiceImpl.updateById(invoiceVerifyPrompt));
  }

  /**
   * 修改-传入修改的数据验真发票提示对象
   * @param invoiceVerifyPrompt 验真发票提示对象
   * @return XfR
   */
  @PatchMapping("/invoiceverifyprompts/{id}")
  public XfR patchUpdate(@RequestBody InvoiceVerifyPrompt invoiceVerifyPrompt,@PathVariable Long id) {
      InvoiceVerifyPrompt upinvoiceVerifyPrompt = invoiceVerifyPromptServiceImpl.getById(id);
      if(upinvoiceVerifyPrompt != null){
        upinvoiceVerifyPrompt = ObjectCopyUtils.copyProperties(invoiceVerifyPrompt,upinvoiceVerifyPrompt,true);
      }
      return XfR.ok(invoiceVerifyPromptServiceImpl.updateById(upinvoiceVerifyPrompt));
  }

  /**
   * 通过id删除验真发票提示对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceverifyprompts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceVerifyPromptServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceverifyprompts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_verify_prompt");
     params.put("request", condition);

     return XfR.ok(invoiceVerifyPromptServiceImpl.querys(params));
  }

}
