package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.TrainTicket;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.ITrainTicketService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 火车票对象前端控制器
 *
 * @author ultraman
 * @date 2025-11-03
 */
@RestController
public class TrainTicketController {

  @Autowired
  private ITrainTicketService trainTicketServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param trainTicket 火车票对象
   * @return
   */
  @GetMapping("/traintickets" )
  public XfR getTrainTickets(XfPage page, TrainTicket trainTicket) {
    return XfR.ok(trainTicketServiceImpl.page(page, Wrappers.query(trainTicket)));
  }

  /**
   * 通过id查询火车票对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/traintickets/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(trainTicketServiceImpl.getById(id));
  }

  /**
   * 新增火车票对象
   * @param trainTicket 火车票对象
   * @return XfR
   */
  @PostMapping("/traintickets")
  public XfR save(@RequestBody TrainTicket trainTicket) {
     return XfR.ok(trainTicketServiceImpl.save(trainTicket));
  }

  /**
   * 修改-传入修改后的全部数据火车票对象
   * @param trainTicket 火车票对象
   * @return XfR
   */
  @PutMapping("/traintickets/{id}")
  public XfR putUpdate(@RequestBody TrainTicket trainTicket,@PathVariable Long id) {
      trainTicket.setId(id);
      return XfR.ok(trainTicketServiceImpl.updateById(trainTicket));
  }

  /**
   * 修改-传入修改的数据火车票对象
   * @param trainTicket 火车票对象
   * @return XfR
   */
  @PatchMapping("/traintickets/{id}")
  public XfR patchUpdate(@RequestBody TrainTicket trainTicket,@PathVariable Long id) {
      TrainTicket uptrainTicket = trainTicketServiceImpl.getById(id);
      if(uptrainTicket != null){
        uptrainTicket = ObjectCopyUtils.copyProperties(trainTicket,uptrainTicket,true);
      }
      return XfR.ok(trainTicketServiceImpl.updateById(uptrainTicket));
  }

  /**
   * 通过id删除火车票对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/traintickets/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(trainTicketServiceImpl.removeById(id));
  }

  @PostMapping("/traintickets/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "train_ticket");
     params.put("request", condition);

     return XfR.ok(trainTicketServiceImpl.querys(params));
  }

}
