package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceEntryLog;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceEntryLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票入账履历前端控制器
 *
 * @author ultraman
 * @date 2025-11-12
 */
@RestController
public class InvoiceEntryLogController {

  @Autowired
  private IInvoiceEntryLogService invoiceEntryLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceEntryLog 发票入账履历
   * @return
   */
  @GetMapping("/invoiceentrylogs" )
  public XfR getInvoiceEntryLogs(XfPage page, InvoiceEntryLog invoiceEntryLog) {
    return XfR.ok(invoiceEntryLogServiceImpl.page(page, Wrappers.query(invoiceEntryLog)));
  }

  /**
   * 通过id查询发票入账履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceentrylogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceEntryLogServiceImpl.getById(id));
  }

  /**
   * 新增发票入账履历
   * @param invoiceEntryLog 发票入账履历
   * @return XfR
   */
  @PostMapping("/invoiceentrylogs")
  public XfR save(@RequestBody InvoiceEntryLog invoiceEntryLog) {
     return XfR.ok(invoiceEntryLogServiceImpl.save(invoiceEntryLog));
  }

  /**
   * 修改-传入修改后的全部数据发票入账履历
   * @param invoiceEntryLog 发票入账履历
   * @return XfR
   */
  @PutMapping("/invoiceentrylogs/{id}")
  public XfR putUpdate(@RequestBody InvoiceEntryLog invoiceEntryLog,@PathVariable Long id) {
      invoiceEntryLog.setId(id);
      return XfR.ok(invoiceEntryLogServiceImpl.updateById(invoiceEntryLog));
  }

  /**
   * 修改-传入修改的数据发票入账履历
   * @param invoiceEntryLog 发票入账履历
   * @return XfR
   */
  @PatchMapping("/invoiceentrylogs/{id}")
  public XfR patchUpdate(@RequestBody InvoiceEntryLog invoiceEntryLog,@PathVariable Long id) {
      InvoiceEntryLog upinvoiceEntryLog = invoiceEntryLogServiceImpl.getById(id);
      if(upinvoiceEntryLog != null){
        upinvoiceEntryLog = ObjectCopyUtils.copyProperties(invoiceEntryLog,upinvoiceEntryLog,true);
      }
      return XfR.ok(invoiceEntryLogServiceImpl.updateById(upinvoiceEntryLog));
  }

  /**
   * 通过id删除发票入账履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceentrylogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceEntryLogServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceentrylogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_entry_log");
     params.put("request", condition);

     return XfR.ok(invoiceEntryLogServiceImpl.querys(params));
  }

}
