package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceNoCompliance;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceNoComplianceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票不合规对象信息前端控制器
 *
 * @author ultraman
 * @date 2025-11-12
 */
@RestController
public class InvoiceNoComplianceController {

  @Autowired
  private IInvoiceNoComplianceService invoiceNoComplianceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceNoCompliance 发票不合规对象信息
   * @return
   */
  @GetMapping("/invoicenocompliances" )
  public XfR getInvoiceNoCompliances(XfPage page, InvoiceNoCompliance invoiceNoCompliance) {
    return XfR.ok(invoiceNoComplianceServiceImpl.page(page, Wrappers.query(invoiceNoCompliance)));
  }

  /**
   * 通过id查询发票不合规对象信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicenocompliances/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceNoComplianceServiceImpl.getById(id));
  }

  /**
   * 新增发票不合规对象信息
   * @param invoiceNoCompliance 发票不合规对象信息
   * @return XfR
   */
  @PostMapping("/invoicenocompliances")
  public XfR save(@RequestBody InvoiceNoCompliance invoiceNoCompliance) {
     return XfR.ok(invoiceNoComplianceServiceImpl.save(invoiceNoCompliance));
  }

  /**
   * 修改-传入修改后的全部数据发票不合规对象信息
   * @param invoiceNoCompliance 发票不合规对象信息
   * @return XfR
   */
  @PutMapping("/invoicenocompliances/{id}")
  public XfR putUpdate(@RequestBody InvoiceNoCompliance invoiceNoCompliance,@PathVariable Long id) {
      invoiceNoCompliance.setId(id);
      return XfR.ok(invoiceNoComplianceServiceImpl.updateById(invoiceNoCompliance));
  }

  /**
   * 修改-传入修改的数据发票不合规对象信息
   * @param invoiceNoCompliance 发票不合规对象信息
   * @return XfR
   */
  @PatchMapping("/invoicenocompliances/{id}")
  public XfR patchUpdate(@RequestBody InvoiceNoCompliance invoiceNoCompliance,@PathVariable Long id) {
      InvoiceNoCompliance upinvoiceNoCompliance = invoiceNoComplianceServiceImpl.getById(id);
      if(upinvoiceNoCompliance != null){
        upinvoiceNoCompliance = ObjectCopyUtils.copyProperties(invoiceNoCompliance,upinvoiceNoCompliance,true);
      }
      return XfR.ok(invoiceNoComplianceServiceImpl.updateById(upinvoiceNoCompliance));
  }

  /**
   * 通过id删除发票不合规对象信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicenocompliances/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceNoComplianceServiceImpl.removeById(id));
  }

  @PostMapping("/invoicenocompliances/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_no_compliance");
     params.put("request", condition);

     return XfR.ok(invoiceNoComplianceServiceImpl.querys(params));
  }

}
