package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.NcpInvoiceJjkcSummary;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.INcpInvoiceJjkcSummaryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-11-12
 */
@RestController
public class NcpInvoiceJjkcSummaryController {

  @Autowired
  private INcpInvoiceJjkcSummaryService ncpInvoiceJjkcSummaryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ncpInvoiceJjkcSummary ${table.comment}
   * @return
   */
  @GetMapping("/ncpinvoicejjkcsummarys" )
  public XfR getNcpInvoiceJjkcSummarys(XfPage page, NcpInvoiceJjkcSummary ncpInvoiceJjkcSummary) {
    return XfR.ok(ncpInvoiceJjkcSummaryServiceImpl.page(page, Wrappers.query(ncpInvoiceJjkcSummary)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ncpinvoicejjkcsummarys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ncpInvoiceJjkcSummaryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ncpInvoiceJjkcSummary ${table.comment}
   * @return XfR
   */
  @PostMapping("/ncpinvoicejjkcsummarys")
  public XfR save(@RequestBody NcpInvoiceJjkcSummary ncpInvoiceJjkcSummary) {
     return XfR.ok(ncpInvoiceJjkcSummaryServiceImpl.save(ncpInvoiceJjkcSummary));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ncpInvoiceJjkcSummary ${table.comment}
   * @return XfR
   */
  @PutMapping("/ncpinvoicejjkcsummarys/{id}")
  public XfR putUpdate(@RequestBody NcpInvoiceJjkcSummary ncpInvoiceJjkcSummary,@PathVariable Long id) {
      ncpInvoiceJjkcSummary.setId(id);
      return XfR.ok(ncpInvoiceJjkcSummaryServiceImpl.updateById(ncpInvoiceJjkcSummary));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ncpInvoiceJjkcSummary ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ncpinvoicejjkcsummarys/{id}")
  public XfR patchUpdate(@RequestBody NcpInvoiceJjkcSummary ncpInvoiceJjkcSummary,@PathVariable Long id) {
      NcpInvoiceJjkcSummary upncpInvoiceJjkcSummary = ncpInvoiceJjkcSummaryServiceImpl.getById(id);
      if(upncpInvoiceJjkcSummary != null){
        upncpInvoiceJjkcSummary = ObjectCopyUtils.copyProperties(ncpInvoiceJjkcSummary,upncpInvoiceJjkcSummary,true);
      }
      return XfR.ok(ncpInvoiceJjkcSummaryServiceImpl.updateById(upncpInvoiceJjkcSummary));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ncpinvoicejjkcsummarys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ncpInvoiceJjkcSummaryServiceImpl.removeById(id));
  }

  @PostMapping("/ncpinvoicejjkcsummarys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ncp_invoice_jjkc_summary");
     params.put("request", condition);

     return XfR.ok(ncpInvoiceJjkcSummaryServiceImpl.querys(params));
  }

}
