package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.NcpInvoicePendingSummary;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.INcpInvoicePendingSummaryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-11-12
 */
@RestController
public class NcpInvoicePendingSummaryController {

  @Autowired
  private INcpInvoicePendingSummaryService ncpInvoicePendingSummaryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ncpInvoicePendingSummary ${table.comment}
   * @return
   */
  @GetMapping("/ncpinvoicependingsummarys" )
  public XfR getNcpInvoicePendingSummarys(XfPage page, NcpInvoicePendingSummary ncpInvoicePendingSummary) {
    return XfR.ok(ncpInvoicePendingSummaryServiceImpl.page(page, Wrappers.query(ncpInvoicePendingSummary)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ncpinvoicependingsummarys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ncpInvoicePendingSummaryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ncpInvoicePendingSummary ${table.comment}
   * @return XfR
   */
  @PostMapping("/ncpinvoicependingsummarys")
  public XfR save(@RequestBody NcpInvoicePendingSummary ncpInvoicePendingSummary) {
     return XfR.ok(ncpInvoicePendingSummaryServiceImpl.save(ncpInvoicePendingSummary));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ncpInvoicePendingSummary ${table.comment}
   * @return XfR
   */
  @PutMapping("/ncpinvoicependingsummarys/{id}")
  public XfR putUpdate(@RequestBody NcpInvoicePendingSummary ncpInvoicePendingSummary,@PathVariable Long id) {
      ncpInvoicePendingSummary.setId(id);
      return XfR.ok(ncpInvoicePendingSummaryServiceImpl.updateById(ncpInvoicePendingSummary));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ncpInvoicePendingSummary ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ncpinvoicependingsummarys/{id}")
  public XfR patchUpdate(@RequestBody NcpInvoicePendingSummary ncpInvoicePendingSummary,@PathVariable Long id) {
      NcpInvoicePendingSummary upncpInvoicePendingSummary = ncpInvoicePendingSummaryServiceImpl.getById(id);
      if(upncpInvoicePendingSummary != null){
        upncpInvoicePendingSummary = ObjectCopyUtils.copyProperties(ncpInvoicePendingSummary,upncpInvoicePendingSummary,true);
      }
      return XfR.ok(ncpInvoicePendingSummaryServiceImpl.updateById(upncpInvoicePendingSummary));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ncpinvoicependingsummarys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ncpInvoicePendingSummaryServiceImpl.removeById(id));
  }

  @PostMapping("/ncpinvoicependingsummarys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ncp_invoice_pending_summary");
     params.put("request", condition);

     return XfR.ok(ncpInvoicePendingSummaryServiceImpl.querys(params));
  }

}
