package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.TravelTicketItem;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.ITravelTicketItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 行程单明细对象前端控制器
 *
 * @author ultraman
 * @date 2025-11-12
 */
@RestController
public class TravelTicketItemController {

  @Autowired
  private ITravelTicketItemService travelTicketItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param travelTicketItem 行程单明细对象
   * @return
   */
  @GetMapping("/travelticketitems" )
  public XfR getTravelTicketItems(XfPage page, TravelTicketItem travelTicketItem) {
    return XfR.ok(travelTicketItemServiceImpl.page(page, Wrappers.query(travelTicketItem)));
  }

  /**
   * 通过id查询行程单明细对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/travelticketitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(travelTicketItemServiceImpl.getById(id));
  }

  /**
   * 新增行程单明细对象
   * @param travelTicketItem 行程单明细对象
   * @return XfR
   */
  @PostMapping("/travelticketitems")
  public XfR save(@RequestBody TravelTicketItem travelTicketItem) {
     return XfR.ok(travelTicketItemServiceImpl.save(travelTicketItem));
  }

  /**
   * 修改-传入修改后的全部数据行程单明细对象
   * @param travelTicketItem 行程单明细对象
   * @return XfR
   */
  @PutMapping("/travelticketitems/{id}")
  public XfR putUpdate(@RequestBody TravelTicketItem travelTicketItem,@PathVariable Long id) {
      travelTicketItem.setId(id);
      return XfR.ok(travelTicketItemServiceImpl.updateById(travelTicketItem));
  }

  /**
   * 修改-传入修改的数据行程单明细对象
   * @param travelTicketItem 行程单明细对象
   * @return XfR
   */
  @PatchMapping("/travelticketitems/{id}")
  public XfR patchUpdate(@RequestBody TravelTicketItem travelTicketItem,@PathVariable Long id) {
      TravelTicketItem uptravelTicketItem = travelTicketItemServiceImpl.getById(id);
      if(uptravelTicketItem != null){
        uptravelTicketItem = ObjectCopyUtils.copyProperties(travelTicketItem,uptravelTicketItem,true);
      }
      return XfR.ok(travelTicketItemServiceImpl.updateById(uptravelTicketItem));
  }

  /**
   * 通过id删除行程单明细对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/travelticketitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(travelTicketItemServiceImpl.removeById(id));
  }

  @PostMapping("/travelticketitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "travel_ticket_item");
     params.put("request", condition);

     return XfR.ok(travelTicketItemServiceImpl.querys(params));
  }

}
