package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.BusinessConfig;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IBusinessConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 配置功能前端控制器
 *
 * @author ultraman
 * @date 2025-11-24
 */
@RestController
public class BusinessConfigController {

  @Autowired
  private IBusinessConfigService businessConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessConfig 配置功能
   * @return
   */
  @GetMapping("/businessconfigs" )
  public XfR getBusinessConfigs(XfPage page, BusinessConfig businessConfig) {
    return XfR.ok(businessConfigServiceImpl.page(page, Wrappers.query(businessConfig)));
  }

  /**
   * 通过id查询配置功能
   * @param  id
   * @return XfR
   */
  @GetMapping("/businessconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessConfigServiceImpl.getById(id));
  }

  /**
   * 新增配置功能
   * @param businessConfig 配置功能
   * @return XfR
   */
  @PostMapping("/businessconfigs")
  public XfR save(@RequestBody BusinessConfig businessConfig) {
     return XfR.ok(businessConfigServiceImpl.save(businessConfig));
  }

  /**
   * 修改-传入修改后的全部数据配置功能
   * @param businessConfig 配置功能
   * @return XfR
   */
  @PutMapping("/businessconfigs/{id}")
  public XfR putUpdate(@RequestBody BusinessConfig businessConfig,@PathVariable Long id) {
      businessConfig.setId(id);
      return XfR.ok(businessConfigServiceImpl.updateById(businessConfig));
  }

  /**
   * 修改-传入修改的数据配置功能
   * @param businessConfig 配置功能
   * @return XfR
   */
  @PatchMapping("/businessconfigs/{id}")
  public XfR patchUpdate(@RequestBody BusinessConfig businessConfig,@PathVariable Long id) {
      BusinessConfig upbusinessConfig = businessConfigServiceImpl.getById(id);
      if(upbusinessConfig != null){
        upbusinessConfig = ObjectCopyUtils.copyProperties(businessConfig,upbusinessConfig,true);
      }
      return XfR.ok(businessConfigServiceImpl.updateById(upbusinessConfig));
  }

  /**
   * 通过id删除配置功能
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businessconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessConfigServiceImpl.removeById(id));
  }

  @PostMapping("/businessconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_config");
     params.put("request", condition);

     return XfR.ok(businessConfigServiceImpl.querys(params));
  }

}
