package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceRecog;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceRecogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票识别相关信息前端控制器
 *
 * @author ultraman
 * @date 2025-11-24
 */
@RestController
public class InvoiceRecogController {

  @Autowired
  private IInvoiceRecogService invoiceRecogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceRecog 发票识别相关信息
   * @return
   */
  @GetMapping("/invoicerecogs" )
  public XfR getInvoiceRecogs(XfPage page, InvoiceRecog invoiceRecog) {
    return XfR.ok(invoiceRecogServiceImpl.page(page, Wrappers.query(invoiceRecog)));
  }

  /**
   * 通过id查询发票识别相关信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicerecogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceRecogServiceImpl.getById(id));
  }

  /**
   * 新增发票识别相关信息
   * @param invoiceRecog 发票识别相关信息
   * @return XfR
   */
  @PostMapping("/invoicerecogs")
  public XfR save(@RequestBody InvoiceRecog invoiceRecog) {
     return XfR.ok(invoiceRecogServiceImpl.save(invoiceRecog));
  }

  /**
   * 修改-传入修改后的全部数据发票识别相关信息
   * @param invoiceRecog 发票识别相关信息
   * @return XfR
   */
  @PutMapping("/invoicerecogs/{id}")
  public XfR putUpdate(@RequestBody InvoiceRecog invoiceRecog,@PathVariable Long id) {
      invoiceRecog.setId(id);
      return XfR.ok(invoiceRecogServiceImpl.updateById(invoiceRecog));
  }

  /**
   * 修改-传入修改的数据发票识别相关信息
   * @param invoiceRecog 发票识别相关信息
   * @return XfR
   */
  @PatchMapping("/invoicerecogs/{id}")
  public XfR patchUpdate(@RequestBody InvoiceRecog invoiceRecog,@PathVariable Long id) {
      InvoiceRecog upinvoiceRecog = invoiceRecogServiceImpl.getById(id);
      if(upinvoiceRecog != null){
        upinvoiceRecog = ObjectCopyUtils.copyProperties(invoiceRecog,upinvoiceRecog,true);
      }
      return XfR.ok(invoiceRecogServiceImpl.updateById(upinvoiceRecog));
  }

  /**
   * 通过id删除发票识别相关信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicerecogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceRecogServiceImpl.removeById(id));
  }

  @PostMapping("/invoicerecogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_recog");
     params.put("request", condition);

     return XfR.ok(invoiceRecogServiceImpl.querys(params));
  }

}
