package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceVerify;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceVerifyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 验真相关信息前端控制器
 *
 * @author ultraman
 * @date 2025-11-24
 */
@RestController
public class InvoiceVerifyController {

  @Autowired
  private IInvoiceVerifyService invoiceVerifyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceVerify 验真相关信息
   * @return
   */
  @GetMapping("/invoiceverifys" )
  public XfR getInvoiceVerifys(XfPage page, InvoiceVerify invoiceVerify) {
    return XfR.ok(invoiceVerifyServiceImpl.page(page, Wrappers.query(invoiceVerify)));
  }

  /**
   * 通过id查询验真相关信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceverifys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceVerifyServiceImpl.getById(id));
  }

  /**
   * 新增验真相关信息
   * @param invoiceVerify 验真相关信息
   * @return XfR
   */
  @PostMapping("/invoiceverifys")
  public XfR save(@RequestBody InvoiceVerify invoiceVerify) {
     return XfR.ok(invoiceVerifyServiceImpl.save(invoiceVerify));
  }

  /**
   * 修改-传入修改后的全部数据验真相关信息
   * @param invoiceVerify 验真相关信息
   * @return XfR
   */
  @PutMapping("/invoiceverifys/{id}")
  public XfR putUpdate(@RequestBody InvoiceVerify invoiceVerify,@PathVariable Long id) {
      invoiceVerify.setId(id);
      return XfR.ok(invoiceVerifyServiceImpl.updateById(invoiceVerify));
  }

  /**
   * 修改-传入修改的数据验真相关信息
   * @param invoiceVerify 验真相关信息
   * @return XfR
   */
  @PatchMapping("/invoiceverifys/{id}")
  public XfR patchUpdate(@RequestBody InvoiceVerify invoiceVerify,@PathVariable Long id) {
      InvoiceVerify upinvoiceVerify = invoiceVerifyServiceImpl.getById(id);
      if(upinvoiceVerify != null){
        upinvoiceVerify = ObjectCopyUtils.copyProperties(invoiceVerify,upinvoiceVerify,true);
      }
      return XfR.ok(invoiceVerifyServiceImpl.updateById(upinvoiceVerify));
  }

  /**
   * 通过id删除验真相关信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceverifys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceVerifyServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceverifys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_verify");
     params.put("request", condition);

     return XfR.ok(invoiceVerifyServiceImpl.querys(params));
  }

}
