package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.MatchBatchOperateHistory;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IMatchBatchOperateHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 配单下发模块前端控制器
 *
 * @author ultraman
 * @date 2025-11-24
 */
@RestController
public class MatchBatchOperateHistoryController {

  @Autowired
  private IMatchBatchOperateHistoryService matchBatchOperateHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param matchBatchOperateHistory 配单下发模块
   * @return
   */
  @GetMapping("/matchbatchoperatehistorys" )
  public XfR getMatchBatchOperateHistorys(XfPage page, MatchBatchOperateHistory matchBatchOperateHistory) {
    return XfR.ok(matchBatchOperateHistoryServiceImpl.page(page, Wrappers.query(matchBatchOperateHistory)));
  }

  /**
   * 通过id查询配单下发模块
   * @param  id
   * @return XfR
   */
  @GetMapping("/matchbatchoperatehistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matchBatchOperateHistoryServiceImpl.getById(id));
  }

  /**
   * 新增配单下发模块
   * @param matchBatchOperateHistory 配单下发模块
   * @return XfR
   */
  @PostMapping("/matchbatchoperatehistorys")
  public XfR save(@RequestBody MatchBatchOperateHistory matchBatchOperateHistory) {
     return XfR.ok(matchBatchOperateHistoryServiceImpl.save(matchBatchOperateHistory));
  }

  /**
   * 修改-传入修改后的全部数据配单下发模块
   * @param matchBatchOperateHistory 配单下发模块
   * @return XfR
   */
  @PutMapping("/matchbatchoperatehistorys/{id}")
  public XfR putUpdate(@RequestBody MatchBatchOperateHistory matchBatchOperateHistory,@PathVariable Long id) {
      matchBatchOperateHistory.setId(id);
      return XfR.ok(matchBatchOperateHistoryServiceImpl.updateById(matchBatchOperateHistory));
  }

  /**
   * 修改-传入修改的数据配单下发模块
   * @param matchBatchOperateHistory 配单下发模块
   * @return XfR
   */
  @PatchMapping("/matchbatchoperatehistorys/{id}")
  public XfR patchUpdate(@RequestBody MatchBatchOperateHistory matchBatchOperateHistory,@PathVariable Long id) {
      MatchBatchOperateHistory upmatchBatchOperateHistory = matchBatchOperateHistoryServiceImpl.getById(id);
      if(upmatchBatchOperateHistory != null){
        upmatchBatchOperateHistory = ObjectCopyUtils.copyProperties(matchBatchOperateHistory,upmatchBatchOperateHistory,true);
      }
      return XfR.ok(matchBatchOperateHistoryServiceImpl.updateById(upmatchBatchOperateHistory));
  }

  /**
   * 通过id删除配单下发模块
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/matchbatchoperatehistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matchBatchOperateHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/matchbatchoperatehistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "match_batch_operate_history");
     params.put("request", condition);

     return XfR.ok(matchBatchOperateHistoryServiceImpl.querys(params));
  }

}
