package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.ProductSplitRule;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IProductSplitRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-11-24
 */
@RestController
public class ProductSplitRuleController {

  @Autowired
  private IProductSplitRuleService productSplitRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param productSplitRule ${table.comment}
   * @return
   */
  @GetMapping("/productsplitrules" )
  public XfR getProductSplitRules(XfPage page, ProductSplitRule productSplitRule) {
    return XfR.ok(productSplitRuleServiceImpl.page(page, Wrappers.query(productSplitRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/productsplitrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productSplitRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param productSplitRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/productsplitrules")
  public XfR save(@RequestBody ProductSplitRule productSplitRule) {
     return XfR.ok(productSplitRuleServiceImpl.save(productSplitRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param productSplitRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/productsplitrules/{id}")
  public XfR putUpdate(@RequestBody ProductSplitRule productSplitRule,@PathVariable Long id) {
      productSplitRule.setId(id);
      return XfR.ok(productSplitRuleServiceImpl.updateById(productSplitRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param productSplitRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/productsplitrules/{id}")
  public XfR patchUpdate(@RequestBody ProductSplitRule productSplitRule,@PathVariable Long id) {
      ProductSplitRule upproductSplitRule = productSplitRuleServiceImpl.getById(id);
      if(upproductSplitRule != null){
        upproductSplitRule = ObjectCopyUtils.copyProperties(productSplitRule,upproductSplitRule,true);
      }
      return XfR.ok(productSplitRuleServiceImpl.updateById(upproductSplitRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/productsplitrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productSplitRuleServiceImpl.removeById(id));
  }

  @PostMapping("/productsplitrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product_split_rule");
     params.put("request", condition);

     return XfR.ok(productSplitRuleServiceImpl.querys(params));
  }

}
