package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceBusiness;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceBusinessService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票业务信息前端控制器
 *
 * @author ultraman
 * @date 2025-12-08
 */
@RestController
public class InvoiceBusinessController {

  @Autowired
  private IInvoiceBusinessService invoiceBusinessServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceBusiness 发票业务信息
   * @return
   */
  @GetMapping("/invoicebusinesss" )
  public XfR getInvoiceBusinesss(XfPage page, InvoiceBusiness invoiceBusiness) {
    return XfR.ok(invoiceBusinessServiceImpl.page(page, Wrappers.query(invoiceBusiness)));
  }

  /**
   * 通过id查询发票业务信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicebusinesss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceBusinessServiceImpl.getById(id));
  }

  /**
   * 新增发票业务信息
   * @param invoiceBusiness 发票业务信息
   * @return XfR
   */
  @PostMapping("/invoicebusinesss")
  public XfR save(@RequestBody InvoiceBusiness invoiceBusiness) {
     return XfR.ok(invoiceBusinessServiceImpl.save(invoiceBusiness));
  }

  /**
   * 修改-传入修改后的全部数据发票业务信息
   * @param invoiceBusiness 发票业务信息
   * @return XfR
   */
  @PutMapping("/invoicebusinesss/{id}")
  public XfR putUpdate(@RequestBody InvoiceBusiness invoiceBusiness,@PathVariable Long id) {
      invoiceBusiness.setId(id);
      return XfR.ok(invoiceBusinessServiceImpl.updateById(invoiceBusiness));
  }

  /**
   * 修改-传入修改的数据发票业务信息
   * @param invoiceBusiness 发票业务信息
   * @return XfR
   */
  @PatchMapping("/invoicebusinesss/{id}")
  public XfR patchUpdate(@RequestBody InvoiceBusiness invoiceBusiness,@PathVariable Long id) {
      InvoiceBusiness upinvoiceBusiness = invoiceBusinessServiceImpl.getById(id);
      if(upinvoiceBusiness != null){
        upinvoiceBusiness = ObjectCopyUtils.copyProperties(invoiceBusiness,upinvoiceBusiness,true);
      }
      return XfR.ok(invoiceBusinessServiceImpl.updateById(upinvoiceBusiness));
  }

  /**
   * 通过id删除发票业务信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicebusinesss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceBusinessServiceImpl.removeById(id));
  }

  @PostMapping("/invoicebusinesss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_business");
     params.put("request", condition);

     return XfR.ok(invoiceBusinessServiceImpl.querys(params));
  }

}
