package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceItemView;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceItemViewService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票明细展示对象前端控制器
 *
 * @author ultraman
 * @date 2025-12-08
 */
@RestController
public class InvoiceItemViewController {

  @Autowired
  private IInvoiceItemViewService invoiceItemViewServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceItemView 发票明细展示对象
   * @return
   */
  @GetMapping("/invoiceitemviews" )
  public XfR getInvoiceItemViews(XfPage page, InvoiceItemView invoiceItemView) {
    return XfR.ok(invoiceItemViewServiceImpl.page(page, Wrappers.query(invoiceItemView)));
  }

  /**
   * 通过id查询发票明细展示对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceitemviews/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceItemViewServiceImpl.getById(id));
  }

  /**
   * 新增发票明细展示对象
   * @param invoiceItemView 发票明细展示对象
   * @return XfR
   */
  @PostMapping("/invoiceitemviews")
  public XfR save(@RequestBody InvoiceItemView invoiceItemView) {
     return XfR.ok(invoiceItemViewServiceImpl.save(invoiceItemView));
  }

  /**
   * 修改-传入修改后的全部数据发票明细展示对象
   * @param invoiceItemView 发票明细展示对象
   * @return XfR
   */
  @PutMapping("/invoiceitemviews/{id}")
  public XfR putUpdate(@RequestBody InvoiceItemView invoiceItemView,@PathVariable Long id) {
      invoiceItemView.setId(id);
      return XfR.ok(invoiceItemViewServiceImpl.updateById(invoiceItemView));
  }

  /**
   * 修改-传入修改的数据发票明细展示对象
   * @param invoiceItemView 发票明细展示对象
   * @return XfR
   */
  @PatchMapping("/invoiceitemviews/{id}")
  public XfR patchUpdate(@RequestBody InvoiceItemView invoiceItemView,@PathVariable Long id) {
      InvoiceItemView upinvoiceItemView = invoiceItemViewServiceImpl.getById(id);
      if(upinvoiceItemView != null){
        upinvoiceItemView = ObjectCopyUtils.copyProperties(invoiceItemView,upinvoiceItemView,true);
      }
      return XfR.ok(invoiceItemViewServiceImpl.updateById(upinvoiceItemView));
  }

  /**
   * 通过id删除发票明细展示对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceitemviews/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceItemViewServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceitemviews/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_item_view");
     params.put("request", condition);

     return XfR.ok(invoiceItemViewServiceImpl.querys(params));
  }

}
