package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceRealEstateSales;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceRealEstateSalesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票不动产销售对象前端控制器
 *
 * @author ultraman
 * @date 2025-12-08
 */
@RestController
public class InvoiceRealEstateSalesController {

  @Autowired
  private IInvoiceRealEstateSalesService invoiceRealEstateSalesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceRealEstateSales 发票不动产销售对象
   * @return
   */
  @GetMapping("/invoicerealestatesaless" )
  public XfR getInvoiceRealEstateSaless(XfPage page, InvoiceRealEstateSales invoiceRealEstateSales) {
    return XfR.ok(invoiceRealEstateSalesServiceImpl.page(page, Wrappers.query(invoiceRealEstateSales)));
  }

  /**
   * 通过id查询发票不动产销售对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicerealestatesaless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceRealEstateSalesServiceImpl.getById(id));
  }

  /**
   * 新增发票不动产销售对象
   * @param invoiceRealEstateSales 发票不动产销售对象
   * @return XfR
   */
  @PostMapping("/invoicerealestatesaless")
  public XfR save(@RequestBody InvoiceRealEstateSales invoiceRealEstateSales) {
     return XfR.ok(invoiceRealEstateSalesServiceImpl.save(invoiceRealEstateSales));
  }

  /**
   * 修改-传入修改后的全部数据发票不动产销售对象
   * @param invoiceRealEstateSales 发票不动产销售对象
   * @return XfR
   */
  @PutMapping("/invoicerealestatesaless/{id}")
  public XfR putUpdate(@RequestBody InvoiceRealEstateSales invoiceRealEstateSales,@PathVariable Long id) {
      invoiceRealEstateSales.setId(id);
      return XfR.ok(invoiceRealEstateSalesServiceImpl.updateById(invoiceRealEstateSales));
  }

  /**
   * 修改-传入修改的数据发票不动产销售对象
   * @param invoiceRealEstateSales 发票不动产销售对象
   * @return XfR
   */
  @PatchMapping("/invoicerealestatesaless/{id}")
  public XfR patchUpdate(@RequestBody InvoiceRealEstateSales invoiceRealEstateSales,@PathVariable Long id) {
      InvoiceRealEstateSales upinvoiceRealEstateSales = invoiceRealEstateSalesServiceImpl.getById(id);
      if(upinvoiceRealEstateSales != null){
        upinvoiceRealEstateSales = ObjectCopyUtils.copyProperties(invoiceRealEstateSales,upinvoiceRealEstateSales,true);
      }
      return XfR.ok(invoiceRealEstateSalesServiceImpl.updateById(upinvoiceRealEstateSales));
  }

  /**
   * 通过id删除发票不动产销售对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicerealestatesaless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceRealEstateSalesServiceImpl.removeById(id));
  }

  @PostMapping("/invoicerealestatesaless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_real_estate_sales");
     params.put("request", condition);

     return XfR.ok(invoiceRealEstateSalesServiceImpl.querys(params));
  }

}
