package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceTransportServices;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceTransportServicesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票货物运输服务对象前端控制器
 *
 * @author ultraman
 * @date 2025-12-08
 */
@RestController
public class InvoiceTransportServicesController {

  @Autowired
  private IInvoiceTransportServicesService invoiceTransportServicesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceTransportServices 发票货物运输服务对象
   * @return
   */
  @GetMapping("/invoicetransportservicess" )
  public XfR getInvoiceTransportServicess(XfPage page, InvoiceTransportServices invoiceTransportServices) {
    return XfR.ok(invoiceTransportServicesServiceImpl.page(page, Wrappers.query(invoiceTransportServices)));
  }

  /**
   * 通过id查询发票货物运输服务对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicetransportservicess/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceTransportServicesServiceImpl.getById(id));
  }

  /**
   * 新增发票货物运输服务对象
   * @param invoiceTransportServices 发票货物运输服务对象
   * @return XfR
   */
  @PostMapping("/invoicetransportservicess")
  public XfR save(@RequestBody InvoiceTransportServices invoiceTransportServices) {
     return XfR.ok(invoiceTransportServicesServiceImpl.save(invoiceTransportServices));
  }

  /**
   * 修改-传入修改后的全部数据发票货物运输服务对象
   * @param invoiceTransportServices 发票货物运输服务对象
   * @return XfR
   */
  @PutMapping("/invoicetransportservicess/{id}")
  public XfR putUpdate(@RequestBody InvoiceTransportServices invoiceTransportServices,@PathVariable Long id) {
      invoiceTransportServices.setId(id);
      return XfR.ok(invoiceTransportServicesServiceImpl.updateById(invoiceTransportServices));
  }

  /**
   * 修改-传入修改的数据发票货物运输服务对象
   * @param invoiceTransportServices 发票货物运输服务对象
   * @return XfR
   */
  @PatchMapping("/invoicetransportservicess/{id}")
  public XfR patchUpdate(@RequestBody InvoiceTransportServices invoiceTransportServices,@PathVariable Long id) {
      InvoiceTransportServices upinvoiceTransportServices = invoiceTransportServicesServiceImpl.getById(id);
      if(upinvoiceTransportServices != null){
        upinvoiceTransportServices = ObjectCopyUtils.copyProperties(invoiceTransportServices,upinvoiceTransportServices,true);
      }
      return XfR.ok(invoiceTransportServicesServiceImpl.updateById(upinvoiceTransportServices));
  }

  /**
   * 通过id删除发票货物运输服务对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicetransportservicess/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceTransportServicesServiceImpl.removeById(id));
  }

  @PostMapping("/invoicetransportservicess/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_transport_services");
     params.put("request", condition);

     return XfR.ok(invoiceTransportServicesServiceImpl.querys(params));
  }

}
