package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.ProductSplitDetail;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IProductSplitDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-12-08
 */
@RestController
public class ProductSplitDetailController {

  @Autowired
  private IProductSplitDetailService productSplitDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param productSplitDetail ${table.comment}
   * @return
   */
  @GetMapping("/productsplitdetails" )
  public XfR getProductSplitDetails(XfPage page, ProductSplitDetail productSplitDetail) {
    return XfR.ok(productSplitDetailServiceImpl.page(page, Wrappers.query(productSplitDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/productsplitdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productSplitDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param productSplitDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/productsplitdetails")
  public XfR save(@RequestBody ProductSplitDetail productSplitDetail) {
     return XfR.ok(productSplitDetailServiceImpl.save(productSplitDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param productSplitDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/productsplitdetails/{id}")
  public XfR putUpdate(@RequestBody ProductSplitDetail productSplitDetail,@PathVariable Long id) {
      productSplitDetail.setId(id);
      return XfR.ok(productSplitDetailServiceImpl.updateById(productSplitDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param productSplitDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/productsplitdetails/{id}")
  public XfR patchUpdate(@RequestBody ProductSplitDetail productSplitDetail,@PathVariable Long id) {
      ProductSplitDetail upproductSplitDetail = productSplitDetailServiceImpl.getById(id);
      if(upproductSplitDetail != null){
        upproductSplitDetail = ObjectCopyUtils.copyProperties(productSplitDetail,upproductSplitDetail,true);
      }
      return XfR.ok(productSplitDetailServiceImpl.updateById(upproductSplitDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/productsplitdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productSplitDetailServiceImpl.removeById(id));
  }

  @PostMapping("/productsplitdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product_split_detail");
     params.put("request", condition);

     return XfR.ok(productSplitDetailServiceImpl.querys(params));
  }

}
