package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceRecogDelete;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.service.IInvoiceRecogDeleteService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 记录被删除的发票前端控制器
 *
 * @author ultraman
 * @date 2025-12-11
 */
@RestController
public class InvoiceRecogDeleteController {

  @Autowired
  private IInvoiceRecogDeleteService invoiceRecogDeleteServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceRecogDelete 记录被删除的发票
   * @return
   */
  @GetMapping("/invoicerecogdeletes" )
  public XfR getInvoiceRecogDeletes(XfPage page, InvoiceRecogDelete invoiceRecogDelete) {
    return XfR.ok(invoiceRecogDeleteServiceImpl.page(page, Wrappers.query(invoiceRecogDelete)));
  }

  /**
   * 通过id查询记录被删除的发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicerecogdeletes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceRecogDeleteServiceImpl.getById(id));
  }

  /**
   * 新增记录被删除的发票
   * @param invoiceRecogDelete 记录被删除的发票
   * @return XfR
   */
  @PostMapping("/invoicerecogdeletes")
  public XfR save(@RequestBody InvoiceRecogDelete invoiceRecogDelete) {
     return XfR.ok(invoiceRecogDeleteServiceImpl.save(invoiceRecogDelete));
  }

  /**
   * 修改-传入修改后的全部数据记录被删除的发票
   * @param invoiceRecogDelete 记录被删除的发票
   * @return XfR
   */
  @PutMapping("/invoicerecogdeletes/{id}")
  public XfR putUpdate(@RequestBody InvoiceRecogDelete invoiceRecogDelete,@PathVariable Long id) {
      invoiceRecogDelete.setId(id);
      return XfR.ok(invoiceRecogDeleteServiceImpl.updateById(invoiceRecogDelete));
  }

  /**
   * 修改-传入修改的数据记录被删除的发票
   * @param invoiceRecogDelete 记录被删除的发票
   * @return XfR
   */
  @PatchMapping("/invoicerecogdeletes/{id}")
  public XfR patchUpdate(@RequestBody InvoiceRecogDelete invoiceRecogDelete,@PathVariable Long id) {
      InvoiceRecogDelete upinvoiceRecogDelete = invoiceRecogDeleteServiceImpl.getById(id);
      if(upinvoiceRecogDelete != null){
        upinvoiceRecogDelete = ObjectCopyUtils.copyProperties(invoiceRecogDelete,upinvoiceRecogDelete,true);
      }
      return XfR.ok(invoiceRecogDeleteServiceImpl.updateById(upinvoiceRecogDelete));
  }

  /**
   * 通过id删除记录被删除的发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicerecogdeletes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceRecogDeleteServiceImpl.removeById(id));
  }

  @PostMapping("/invoicerecogdeletes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_recog_delete");
     params.put("request", condition);

     return XfR.ok(invoiceRecogDeleteServiceImpl.querys(params));
  }

}
