package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


/**
 * 验真相关信息feign客户端
 *
 * @author ultraman
 * @date 2022-12-02
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.InvoiceVerify;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-saas")
public interface InvoiceVerifyFeignApi {

  /**
   * 通过id查询验真相关信息
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceVerify/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增验真相关信息
   * @param invoiceVerify 验真相关信息
   * @return R
   */
  @PostMapping("/invoiceVerify/add")
  public R save(@RequestBody InvoiceVerify invoiceVerify);

  /**
   * 修改验真相关信息
   * @param invoiceVerify 验真相关信息
   * @return R
   */
  @PostMapping("/invoiceVerify/update")
  public R updateById(@RequestBody InvoiceVerify invoiceVerify);

  /**
   * 通过id删除验真相关信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceVerify/del/{id}" )
  public R removeById(@PathVariable Long id);

}