package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


/**
 * 发票验真请求记录feign客户端
 *
 * @author ultraman
 * @date 2022-12-02
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.InvoiceVerifyTask;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-saas")
public interface InvoiceVerifyTaskFeignApi {

  /**
   * 通过id查询发票验真请求记录
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceVerifyTask/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票验真请求记录
   * @param invoiceVerifyTask 发票验真请求记录
   * @return R
   */
  @PostMapping("/invoiceVerifyTask/add")
  public R save(@RequestBody InvoiceVerifyTask invoiceVerifyTask);

  /**
   * 修改发票验真请求记录
   * @param invoiceVerifyTask 发票验真请求记录
   * @return R
   */
  @PostMapping("/invoiceVerifyTask/update")
  public R updateById(@RequestBody InvoiceVerifyTask invoiceVerifyTask);

  /**
   * 通过id删除发票验真请求记录
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceVerifyTask/del/{id}" )
  public R removeById(@PathVariable Long id);

}