package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


/**
 * 发票明细对象信息feign客户端
 *
 * @author ultraman
 * @date 2022-06-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.InvoiceItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-saas")
public interface InvoiceItemFeignApi {

  /**
   * 通过id查询发票明细对象信息
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票明细对象信息
   * @param invoiceItem 发票明细对象信息
   * @return R
   */
  @PostMapping("/invoiceItem/add")
  public R save(@RequestBody InvoiceItem invoiceItem);

  /**
   * 修改发票明细对象信息
   * @param invoiceItem 发票明细对象信息
   * @return R
   */
  @PostMapping("/invoiceItem/update")
  public R updateById(@RequestBody InvoiceItem invoiceItem);

  /**
   * 通过id删除发票明细对象信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}