package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


/**
 * 发票业务信息feign客户端
 *
 * @author ultraman
 * @date 2022-06-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.InvoiceBusiness;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-saas")
public interface InvoiceBusinessFeignApi {

  /**
   * 通过id查询发票业务信息
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceBusiness/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票业务信息
   * @param invoiceBusiness 发票业务信息
   * @return R
   */
  @PostMapping("/invoiceBusiness/add")
  public R save(@RequestBody InvoiceBusiness invoiceBusiness);

  /**
   * 修改发票业务信息
   * @param invoiceBusiness 发票业务信息
   * @return R
   */
  @PostMapping("/invoiceBusiness/update")
  public R updateById(@RequestBody InvoiceBusiness invoiceBusiness);

  /**
   * 通过id删除发票业务信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceBusiness/del/{id}" )
  public R removeById(@PathVariable Long id);

}