package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


/**
 * 发票配单相关信息feign客户端
 *
 * @author ultraman
 * @date 2022-06-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.InvoiceMatch;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-saas")
public interface InvoiceMatchFeignApi {

  /**
   * 通过id查询发票配单相关信息
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceMatch/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票配单相关信息
   * @param invoiceMatch 发票配单相关信息
   * @return R
   */
  @PostMapping("/invoiceMatch/add")
  public R save(@RequestBody InvoiceMatch invoiceMatch);

  /**
   * 修改发票配单相关信息
   * @param invoiceMatch 发票配单相关信息
   * @return R
   */
  @PostMapping("/invoiceMatch/update")
  public R updateById(@RequestBody InvoiceMatch invoiceMatch);

  /**
   * 通过id删除发票配单相关信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceMatch/del/{id}" )
  public R removeById(@PathVariable Long id);

}