package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


/**
 * 海关缴款书明细对象feign客户端
 *
 * @author ultraman
 * @date 2023-08-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.CustomsPaymentItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-saas")
public interface CustomsPaymentItemFeignApi {

  /**
   * 通过id查询海关缴款书明细对象
   * @param  id
   * @return R
   */
  @GetMapping("/customsPaymentItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增海关缴款书明细对象
   * @param customsPaymentItem 海关缴款书明细对象
   * @return R
   */
  @PostMapping("/customsPaymentItem/add")
  public R save(@RequestBody CustomsPaymentItem customsPaymentItem);

  /**
   * 修改海关缴款书明细对象
   * @param customsPaymentItem 海关缴款书明细对象
   * @return R
   */
  @PostMapping("/customsPaymentItem/update")
  public R updateById(@RequestBody CustomsPaymentItem customsPaymentItem);

  /**
   * 通过id删除海关缴款书明细对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/customsPaymentItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}