package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


/**
 * 农产品发票处理任务对象feign客户端
 *
 * @author ultraman
 * @date 2023-08-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.NcpInvoiceHandleTask;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-saas")
public interface NcpInvoiceHandleTaskFeignApi {

  /**
   * 通过id查询农产品发票处理任务对象
   * @param  id
   * @return R
   */
  @GetMapping("/ncpInvoiceHandleTask/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增农产品发票处理任务对象
   * @param ncpInvoiceHandleTask 农产品发票处理任务对象
   * @return R
   */
  @PostMapping("/ncpInvoiceHandleTask/add")
  public R save(@RequestBody NcpInvoiceHandleTask ncpInvoiceHandleTask);

  /**
   * 修改农产品发票处理任务对象
   * @param ncpInvoiceHandleTask 农产品发票处理任务对象
   * @return R
   */
  @PostMapping("/ncpInvoiceHandleTask/update")
  public R updateById(@RequestBody NcpInvoiceHandleTask ncpInvoiceHandleTask);

  /**
   * 通过id删除农产品发票处理任务对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/ncpInvoiceHandleTask/del/{id}" )
  public R removeById(@PathVariable Long id);

}