package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


/**
 * 发票推送下游履历feign客户端
 *
 * @author ultraman
 * @date 2023-09-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.InvoicePushLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-saas")
public interface InvoicePushLogFeignApi {

  /**
   * 通过id查询发票推送下游履历
   * @param  id
   * @return R
   */
  @GetMapping("/invoicePushLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票推送下游履历
   * @param invoicePushLog 发票推送下游履历
   * @return R
   */
  @PostMapping("/invoicePushLog/add")
  public R save(@RequestBody InvoicePushLog invoicePushLog);

  /**
   * 修改发票推送下游履历
   * @param invoicePushLog 发票推送下游履历
   * @return R
   */
  @PostMapping("/invoicePushLog/update")
  public R updateById(@RequestBody InvoicePushLog invoicePushLog);

  /**
   * 通过id删除发票推送下游履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoicePushLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}