package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


/**
 * 页面用户自定义配置feign客户端
 *
 * @author ultraman
 * @date 2023-10-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.UltramanSysBoUserSetting;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-saas")
public interface UltramanSysBoUserSettingFeignApi {

  /**
   * 通过id查询页面用户自定义配置
   * @param  id
   * @return R
   */
  @GetMapping("/ultramanSysBoUserSetting/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增页面用户自定义配置
   * @param ultramanSysBoUserSetting 页面用户自定义配置
   * @return R
   */
  @PostMapping("/ultramanSysBoUserSetting/add")
  public R save(@RequestBody UltramanSysBoUserSetting ultramanSysBoUserSetting);

  /**
   * 修改页面用户自定义配置
   * @param ultramanSysBoUserSetting 页面用户自定义配置
   * @return R
   */
  @PostMapping("/ultramanSysBoUserSetting/update")
  public R updateById(@RequestBody UltramanSysBoUserSetting ultramanSysBoUserSetting);

  /**
   * 通过id删除页面用户自定义配置
   * @param  id
   * @return R
   */
  @DeleteMapping("/ultramanSysBoUserSetting/del/{id}" )
  public R removeById(@PathVariable Long id);

}