package com.xforceplus.ultraman.app.purchaserinvoicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 认证状态
 * </p>
 *
 * @author ultraman
 * @since 2023-04-06
 */
public enum AuthStatus {

    _1("1", "不可勾选"),
    _2("2", "未勾选"),
    _3("3", "勾选中"),
    _4("4", "已勾选"),
    _5("5", "勾选失败"),
    _6("6", "抵扣异常"),
    _8("8", "已确认抵扣");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuthStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "8":
                return _8;
            default:
                return null;
        }
    }
}
