package com.xforceplus.ultraman.app.purchaserinvoicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 反馈状态
 * </p>
 *
 * @author ultraman
 * @since 2023-04-06
 */
public enum BackStatus {

    _1("1", "接收成功"),
    _2("2", "接收失败"),
    _0("0", "未接收");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BackStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BackStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
