package com.xforceplus.ultraman.app.purchaserinvoicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 农产品处理状态
 * </p>
 *
 * @author ultraman
 * @since 2023-04-06
 */
public enum NcpHandleStatus {

    _0("0", "未处理"),
    _1("1", "处理中"),
    _2("2", "处理成功"),
    _3("3", "处理失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NcpHandleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpHandleStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
