package com.xforceplus.ultraman.app.purchaserinvoicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 不合规类型
 * </p>
 *
 * @author ultraman
 * @since 2023-04-06
 */
public enum NoComplianceType {

    _0("0", "无"),
    _1("1", "购方抬头不一致"),
    _2("2", "购方地址电话不一致"),
    _3("3", "购方银行账号不一致"),
    _4("4", "销方失信"),
    _5("5", "敏感词"),
    _6("6", "发票状态异常"),
    _7("7", "购方公司未维护");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NoComplianceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoComplianceType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
