package com.xforceplus.ultraman.app.purchaserinvoicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 特殊发票标记
 * </p>
 *
 * @author ultraman
 * @since 2023-04-06
 */
public enum SpecialInvoiceFlag {

    _0("0", "无"),
    _1("1", "通行费"),
    _2("2", "成品油"),
    _3("3", "区块链"),
    _5("5", "建筑服务"),
    _6("6", "货物运输服务"),
    _7("7", "不动产销售"),
    _8("8", "不动产经营租赁服务");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SpecialInvoiceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SpecialInvoiceFlag fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            default:
                return null;
        }
    }
}
