package com.xforceplus.ultraman.app.purchaserinvoicesaas.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 认证相关信息
 * </p>
 *
 * @author ultraman
 * @since 2023-04-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceAuth implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 组织id
   */
  private Long orgId;

  /**
   * 勾选人id
   */
  private Long checkUserId;

  /**
   * 勾选时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;

  /**
   * 数据状态
   */
  private String dataStatus;

  /**
   * 认证方式
   */
  private String authStyle;

  /**
   * 抵扣用途
   */
  private String authUse;

  /**
   * 认证备注
   */
  private String authRemark;

  /**
   * 认证状态
   */
  private String authStatus;

  /**
   * 可抵扣税额
   */
  private BigDecimal effectiveTaxAmount;

  /**
   * 不抵扣原因
   */
  private String noAuthReason;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 勾选人姓名
   */
  private String checkUserName;

  /**
   * 底账确认日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authBussiDate;

  /**
   * 税款所属期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authTaxPeriod;

  /**
   * 底账获取时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime elTime;

  /**
   * 任务id
   */
  private String authTaskId;

  /**
   * 税件错误码
   */
  private String authTaxErrorCode;

  /**
   * 底账是否已到
   */
  private String elSyncFlag;

  /**
   * 农产品类型
   */
  private String ncpType;

  /**
   * 农产品处理类型
   */
  private String ncpHandleType;

  /**
   * 农产品处理状态
   */
  private String ncpHandleStatus;

  /**
   * 农产品处理时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime ncpHandleTime;

  /**
   * 农产品处理人姓名
   */
  private String ncpHandleUserName;

  /**
   * 农产品处理备注
   */
  private String ncpHandleRemark;

  /**
   * 农产品部分金额
   */
  private BigDecimal ncpPartAmount;

  /**
   * 发票风险等级
   */
  private String ncpManageStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("org_id", orgId);
      map.put("check_user_id", checkUserId);
      map.put("check_time", BocpGenUtils.toTimestamp(checkTime));
      map.put("data_status", dataStatus);
      map.put("auth_style", authStyle);
      map.put("auth_use", authUse);
      map.put("auth_remark", authRemark);
      map.put("auth_status", authStatus);
      map.put("effective_tax_amount", effectiveTaxAmount);
      map.put("no_auth_reason", noAuthReason);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("check_user_name", checkUserName);
      map.put("auth_bussi_date", BocpGenUtils.toTimestamp(authBussiDate));
      map.put("auth_tax_period", BocpGenUtils.toTimestamp(authTaxPeriod));
      map.put("el_time", BocpGenUtils.toTimestamp(elTime));
      map.put("auth_task_id", authTaskId);
      map.put("auth_tax_error_code", authTaxErrorCode);
      map.put("el_sync_flag", elSyncFlag);
      map.put("ncp_type", ncpType);
      map.put("ncp_handle_type", ncpHandleType);
      map.put("ncp_handle_status", ncpHandleStatus);
      map.put("ncp_handle_time", BocpGenUtils.toTimestamp(ncpHandleTime));
      map.put("ncp_handle_user_name", ncpHandleUserName);
      map.put("ncp_handle_remark", ncpHandleRemark);
      map.put("ncp_part_amount", ncpPartAmount);
      map.put("ncp_manage_status", ncpManageStatus);
      return map;
  }

  public static InvoiceAuth fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceAuth entity = new InvoiceAuth();
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStyle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("no_auth_reason")) {
      Object obj = map.get("no_auth_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNoAuthReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthBussiDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuthBussiDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthBussiDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthBussiDate(null);
      }
    }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuthTaxPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthTaxPeriod(null);
      }
    }
    if(map.containsKey("el_time")) {
      Object obj = map.get("el_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setElTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setElTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setElTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setElTime(null);
      }
    }
    if(map.containsKey("auth_task_id")) {
      Object obj = map.get("auth_task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_tax_error_code")) {
      Object obj = map.get("auth_tax_error_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthTaxErrorCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("el_sync_flag")) {
      Object obj = map.get("el_sync_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setElSyncFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_type")) {
      Object obj = map.get("ncp_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNcpType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_type")) {
      Object obj = map.get("ncp_handle_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNcpHandleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_status")) {
      Object obj = map.get("ncp_handle_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNcpHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_time")) {
      Object obj = map.get("ncp_handle_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNcpHandleTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setNcpHandleTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setNcpHandleTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setNcpHandleTime(null);
      }
    }
    if(map.containsKey("ncp_handle_user_name")) {
      Object obj = map.get("ncp_handle_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNcpHandleUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_remark")) {
      Object obj = map.get("ncp_handle_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNcpHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_part_amount")) {
      Object obj = map.get("ncp_part_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNcpPartAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNcpPartAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNcpPartAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setNcpPartAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNcpPartAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ncp_manage_status")) {
      Object obj = map.get("ncp_manage_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNcpManageStatus((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCheckUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCheckTime(null);
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStyle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthUse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("no_auth_reason")) {
      Object obj = map.get("no_auth_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNoAuthReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuthBussiDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuthBussiDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setAuthBussiDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuthBussiDate(null);
      }
    }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuthTaxPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuthTaxPeriod(null);
      }
    }
    if(map.containsKey("el_time")) {
      Object obj = map.get("el_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setElTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setElTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setElTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setElTime(null);
      }
    }
    if(map.containsKey("auth_task_id")) {
      Object obj = map.get("auth_task_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthTaskId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_tax_error_code")) {
      Object obj = map.get("auth_tax_error_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthTaxErrorCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("el_sync_flag")) {
      Object obj = map.get("el_sync_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setElSyncFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_type")) {
      Object obj = map.get("ncp_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_handle_type")) {
      Object obj = map.get("ncp_handle_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpHandleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_handle_status")) {
      Object obj = map.get("ncp_handle_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_handle_time")) {
      Object obj = map.get("ncp_handle_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setNcpHandleTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setNcpHandleTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setNcpHandleTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setNcpHandleTime(null);
      }
    }
    if(map.containsKey("ncp_handle_user_name")) {
      Object obj = map.get("ncp_handle_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpHandleUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_handle_remark")) {
      Object obj = map.get("ncp_handle_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpHandleRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_part_amount")) {
      Object obj = map.get("ncp_part_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setNcpPartAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setNcpPartAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setNcpPartAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setNcpPartAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setNcpPartAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("ncp_manage_status")) {
      Object obj = map.get("ncp_manage_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpManageStatus((String)obj);
        }
      } else {
      }
    }
  }
}
