package com.xforceplus.ultraman.app.purchaserinvoicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件后缀
 * </p>
 *
 * @author ultraman
 * @since 2022-09-22
 */
public enum FileSuffix {

    _0("0", "无"),
    _1("1", "jpg"),
    _2("2", "png"),
    _3("3", "pdf"),
    _4("4", "ofd"),
    _5("5", "jpeg"),
    _6("6", "xml");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FileSuffix(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileSuffix fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
