package com.xforceplus.ultraman.app.purchaserinvoicesaas.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceCheckTask implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 购方税号
   */
  private String purchaserTaxNo;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 税件勾选任务ID
   */
  private String taxTaskId;

  /**
   * 处理状态
   */
  private String processStatus;

  /**
   * 处理备注
   */
  private String processRemark;

  /**
   * 税件请求状态码
   */
  private String requestTaxCode;

  /**
   * 税件请求消息
   */
  private String requestTaxMessage;

  /**
   * 勾选请求时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime requestTime;

  /**
   * 勾选请求内容
   */
  private String requestData;

  /**
   * 税件响应状态码
   */
  private String responseTaxCode;

  /**
   * 税件响应消息
   */
  private String responseTaxMessage;

  /**
   * 勾选响应时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime responseTime;

  /**
   * 勾选响应内容
   */
  private String responseData;

  /**
   * 税件响应错误码
   */
  private String responseTaxErrorCode;

  /**
   * 认证状态
   */
  private String authStatus;

  /**
   * 抵扣用途
   */
  private String authUse;

  /**
   * 认证方式
   */
  private String authStyle;

  /**
   * 税款所属期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authTaxPeriod;

  /**
   * 不抵扣原因
   */
  private String noAuthReason;

  /**
   * 可抵扣税额
   */
  private BigDecimal effectiveTaxAmount;

  /**
   * 批次号
   */
  private String batchNo;

  /**
   * 扩展属性
   */
  private String extProperty;

  /**
   * 勾选耗时
   */
  private Long elapsedTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("tax_task_id", taxTaskId);
      map.put("process_status", processStatus);
      map.put("process_remark", processRemark);
      map.put("request_tax_code", requestTaxCode);
      map.put("request_tax_message", requestTaxMessage);
      map.put("request_time", BocpGenUtils.toTimestamp(requestTime));
      map.put("request_data", requestData);
      map.put("response_tax_code", responseTaxCode);
      map.put("response_tax_message", responseTaxMessage);
      map.put("response_time", BocpGenUtils.toTimestamp(responseTime));
      map.put("response_data", responseData);
      map.put("response_tax_error_code", responseTaxErrorCode);
      map.put("auth_status", authStatus);
      map.put("auth_use", authUse);
      map.put("auth_style", authStyle);
      map.put("auth_tax_period", BocpGenUtils.toTimestamp(authTaxPeriod));
      map.put("no_auth_reason", noAuthReason);
      map.put("effective_tax_amount", effectiveTaxAmount);
      map.put("batch_no", batchNo);
      map.put("ext_property", extProperty);
      map.put("elapsed_time", elapsedTime);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static InvoiceCheckTask fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceCheckTask entity = new InvoiceCheckTask();
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_task_id")) {
      Object obj = map.get("tax_task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("process_status")) {
      Object obj = map.get("process_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcessStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("process_remark")) {
      Object obj = map.get("process_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_tax_code")) {
      Object obj = map.get("request_tax_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestTaxCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_tax_message")) {
      Object obj = map.get("request_tax_message");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestTaxMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_time")) {
      Object obj = map.get("request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRequestTime(null);
      }
    }
    if(map.containsKey("request_data")) {
      Object obj = map.get("request_data");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestData((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("response_tax_code")) {
      Object obj = map.get("response_tax_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponseTaxCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("response_tax_message")) {
      Object obj = map.get("response_tax_message");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponseTaxMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("response_time")) {
      Object obj = map.get("response_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setResponseTime(null);
      }
    }
    if(map.containsKey("response_data")) {
      Object obj = map.get("response_data");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponseData((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("response_tax_error_code")) {
      Object obj = map.get("response_tax_error_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponseTaxErrorCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStyle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthTaxPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthTaxPeriod(null);
      }
    }
    if(map.containsKey("no_auth_reason")) {
      Object obj = map.get("no_auth_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNoAuthReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext_property")) {
      Object obj = map.get("ext_property");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("elapsed_time")) {
      Object obj = map.get("elapsed_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setElapsedTime((Long)obj);
        } else if(obj instanceof String) {
          entity.setElapsedTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setElapsedTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
